<?php
function get_cluster_id_by_name( $argv ) {
	global $DTASCFG_XML_FILE ;

	/* check number of arguments */
	if( count( $argv ) != 1 ) {
		echo "Usage: get_cluster_id_by_name CLUSTER_NAME\n" ;
		exit( 1 ) ;
	}

	$cluster_name = $argv[ 0 ] ;
	$xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $db_host     = chop( $xml->db->host ) ;
    $db_username = chop( $xml->db->username ) ;
    $db_password = $xml->db->password;
	
	$connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_username password=$db_password" ) ;
	if( $connection == false ) {
		echo "ConnectToDbFail: host='$db_host', user='$db_username'" ;
		exit( 1 ) ;
	}

	
	# get all available sc_id
	$query_result = pg_query( "SELECT sc_id FROM tb_sc_info" ) ;
	if( $query_result == false ) {
		echo 'pg_query: ' . pg_last_error();
        pg_close( $connection ) ;
		exit( 1 ) ;
	}

	$sc_id_list = pg_fetch_all_columns( $query_result, 0 ) ;
	if( count( $sc_id_list ) <= 2 ) {
		echo "" ;
        pg_close( $connection ) ;
		exit( 0 ) ;
	}
	
	foreach( $sc_id_list as $sc_id ) {
		if( $sc_id == "0" || $sc_id == "1" ) {
			continue ;
		}
		
		$query_result = $xml -> xpath( "/configuration/cluster_$sc_id/name" ) ;
		if( count( $query_result ) == 0 ) {
			continue ;
		}
		
		$candidate_name = $query_result[ 0 ] ;
		if( strcasecmp( $candidate_name, $cluster_name ) == 0 ) {
			echo "$sc_id" ;
            pg_close( $connection ) ;
			exit( 0 ) ;
		}
	}

	echo "" ;
    pg_close( $connection ) ;
	exit( 1 ) ;
}

